# 画面設計書 8-403ページ (Forbidden)

## 概要

App Routerにおいてアクセス権限がない場合に表示されるデフォルトの403エラーフォールバックの設計書。`forbidden()`関数呼び出し時に表示される。

### 本画面の処理概要

**業務上の目的・背景**：App Routerを使用するNext.jsアプリケーションにおいて、認証済みだがアクセス権限がないリソースにアクセスした場合、適切なエラーメッセージを表示する必要がある。本コンポーネントは、Server ComponentやRoute Handler内で`forbidden()`関数が呼び出された際に表示されるデフォルトの403フォールバックページである。ユーザーがセグメントレベルの`forbidden.tsx`を作成している場合はそちらが優先される。HTTPステータスコード403（Forbidden）に対応し、「This page could not be accessed.」メッセージを表示する。

**画面へのアクセス方法**：Server ComponentまたはRoute Handler内で`forbidden()`関数が呼び出された場合に自動的に表示される。直接URLでアクセスする画面ではない。

**主要な操作・処理内容**：
1. `HTTPAccessErrorFallback`コンポーネントにstatus=403とmessage="This page could not be accessed."を渡して表示する
2. HTTPAccessErrorFallbackコンポーネントが、ステータスコード「403」とメッセージを中央配置で表示する
3. ダークモード対応のCSSが自動適用される

**画面遷移**：
- 遷移元：App Routerのforbidden()関数呼び出し時
- 遷移先：特になし（エラー表示のみ）

**権限による表示制御**：本画面自体がアクセス権限不足時に表示される画面であり、追加の権限制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | エラーハンドリング | 主機能 | アクセス権限なし時の403エラーフォールバック表示 |
| 13 | App Router | 補助機能 | App Routerのforbidden()関数呼び出しとの連携 |

## 画面種別

エラー表示（403フォールバック）

## URL/ルーティング

特定のURLパターンは持たない。forbidden()が呼び出された際のURLのまま403ステータスで表示される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし | - | - | - | 本コンポーネントはプロパティを受け取らない |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ステータスコード | h1要素（左側） | 「403」を表示 |
| エラーメッセージ | h2要素（右側） | 「This page could not be accessed.」を表示 |
| ページタイトル | titleタグ | 「403: This page could not be accessed.」 |

## イベント仕様

### 1-なし

本画面にはユーザー操作可能なインタラクティブ要素は存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベースへのアクセスを行わない |

### テーブル別更新項目詳細

データベース操作なし。

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|----------------|
| MSG-403 | エラー | 常時表示 | This page could not be accessed. |

## 例外処理

| 例外条件 | 挙動 |
|----------|------|
| なし | 本コンポーネントは常に同一の403エラー表示を行う |

## 備考

- App Routerで使用される
- `HTTPAccessErrorFallback`コンポーネントを共有しており、404ページ（No.4, No.5）、401ページ（No.9）と同じ表示パターンを使用
- ユーザーがセグメントレベルの`forbidden.tsx`を作成することでカスタマイズ可能
- html/bodyタグを含まない。親レイアウト内に埋め込まれて表示される
- 404ページ（No.5）と同様のシンプルな構成で、ステータスコードとメッセージのみが異なる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-8: HTTPAccessErrorFallbackのプロパティ型（status: number, message: string） |

**読解のコツ**: No.4, No.5, No.9と全く同じHTTPAccessErrorFallbackコンポーネントを使用する。ステータスコード（403）とメッセージが異なるのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | forbidden.tsx | `packages/next/src/client/components/builtin/forbidden.tsx` | L1-10: Forbidden関数コンポーネント全体 |

**主要処理フロー**:
1. **L1**: `HTTPAccessErrorFallback`をインポート
2. **L3**: `Forbidden`関数コンポーネントの定義（default export）
3. **L5-8**: `HTTPAccessErrorFallback`にstatus=403、message="This page could not be accessed."を渡してレンダリング

#### Step 3: HTTPAccessErrorFallbackコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-45: 表示ロジック全体 |
| 3-2 | access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | L1-34: 共通スタイル定義 |

### プログラム呼び出し階層図

```
App Router (forbidden()呼び出し検出)
    |
    +-- 親レイアウト
            |
            +-- Forbidden コンポーネント
                    |
                    +-- HTTPAccessErrorFallback
                            |
                            +-- status=403, message="This page could not be accessed."
                            +-- access-error-styles (CSS)
                            +-- ダークモードCSS (inline)
```

### データフロー図

```
[入力]               [処理]                           [出力]

(なし) -----------> Forbidden() ----------------> ReactElement
                    |                              - <title> "403: This page..."
                    +-- HTTPAccessErrorFallback     - <h1> "403"
                        (status=403,               - <h2> "This page could..."
                         message="This page...")   - inline CSS (dark mode)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| forbidden.tsx | `packages/next/src/client/components/builtin/forbidden.tsx` | ソース | 403ページのメインコンポーネント |
| error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | ソース | HTTP Access Errorのフォールバック表示コンポーネント |
| access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | ソース | Access Errorページの共通スタイル定義 |
